<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * ArticlesController
 * 
 * Handles the actions for artciles related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class ContactController extends Controller
{
    /**
     * List available published articles 
     */
  public function init(){
	 
        // register class paths for extension captcha extended
        Yii::$classMap = array_merge( Yii::$classMap, array(
            'CaptchaExtendedAction' => Yii::getPathOfAlias('root.apps.extensions.captchaExtended').DIRECTORY_SEPARATOR.'CaptchaExtendedAction.php',
            'CaptchaExtendedValidator' => Yii::getPathOfAlias('root.apps.extensions.captchaExtended').DIRECTORY_SEPARATOR.'CaptchaExtendedValidator.php'
        ));
    }
    public function actionIndex()
    {
		
		$this->layout =   Yii::app()->LayoutClass->layoutpath("fullwidth"); 
		$model = new ContactUs;
		if (isset($_POST['ajax'])) {
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
        if (Yii::app()->request->isPostRequest && ($attributes = (array)Yii::app()->request->getPost($model->modelName, array()))) {
		
		$model->attributes = $attributes;
		if($model->save())
		{
			
			
			$emailTemplate =  CustomerEmailTemplate::model()->findByName("contact us");
			    if($emailTemplate)
			    {
					 $emailTemplate = $emailTemplate->content;
				}
				else
				{
					    $emailTemplate = $options->get('system.email_templates.common');
				}
				 
                
         
                $logo =  '<a href="'.Yii::app()->createUrl("").'" alt="noimage"><img src="'. Yii::app()->params['uploadDir']."/logo/" .Yii::app()->options->get('system.common.logo').'" style="width:134px;height:56px;"></a> ';
                $emailTemplate = str_replace('{logo}',$logo, $emailTemplate);
                $emailTemplate = str_replace('{name}',$model->name, $emailTemplate);
                $emailTemplate = str_replace('{phone}', $model->phone, $emailTemplate);
                $emailTemplate = str_replace('{email}', $model->email, $emailTemplate);
                $emailTemplate = str_replace('{message}', nl2br($model->meassage), $emailTemplate);
                $emailTemplate = str_replace('{subject}',  $model->getType($model->type) , $emailTemplate);
                
         
			   
			    $params = array(
				'to'            =>   Yii::app()->options->get('system.common.admin_email'),
				'fromName'      =>   Yii::app()->options->get('system.common.site_name'),
				'subject'       =>	'Successfully submittted contact form  '.Yii::app()->options->get('system.common.site_name') . '  ',
				'body'          =>   $emailTemplate,
				 'mailerPlugins' => array(
                'logger'    => true,
            ),
				       
				 );
				 $mapping = DeliveryServer::getTypesMapping();
				 $server = DeliveryServer::model($mapping['smtp'])->findByPk((int)4);
				 $server->sendEmail($params) ;
				 Yii::app()->user->setFlash('success',"Your message was successfully sent to the ". Yii::app()->options->get('system.common.site_name')." Support Team. One of our representative will contact you soon. ");
				 $this->refresh() ;
		}
		else
		{
			Yii::app()->user->setFlash('error',"Please fix the following Errors");
		}
	    }
		 
     
        $this->setData(array(
            'pageMetaTitle'     =>Yii::app()->options->get('system.common.site_name').' | '.Yii::t('articles', 'Contact Us'), 
            'pageBreadcrumbs'   => array()
        ));

        $this->render(Yii::app()->LayoutClass->viewpath("index"), compact('model'));
    }
    
   
}
